/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.remoteservice.getversion;

import de.eobs.setuptool.event.RemoteServiceAbortEvent;
import de.eobs.setuptool.eventbus.EventBus;
import de.eobs.setuptool.eventbus.EventHandler;
import de.eobs.setuptool.remoteservice.RemoteService;
import de.eobs.setuptool.remoteservice.RemoteServiceProgressPanel;
import de.eobs.setuptool.remoteservice.getversion.TestRemoteServiceEvent;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetVersionProgressDialog {
    private static final Logger logger = LoggerFactory.getLogger(GetVersionProgressDialog.class);
    private JDialog dialog;
    private final EventBus eventBus;
    private JFrame frame;
    private final RemoteService remoteService;

    public GetVersionProgressDialog(JFrame frame, EventBus eventBus, RemoteService remoteService) {
        this.frame = frame;
        this.eventBus = eventBus;
        this.remoteService = remoteService;
    }

    @EventHandler(swingEDT=true)
    public void handle(TestRemoteServiceEvent event) {
        logger.info("" + event);
        RemoteServiceProgressPanel panel = new RemoteServiceProgressPanel();
        panel.updateText("connecting server...");
        this.remoteService.getVersion(new RemoteService.GetVersionHandler(){

            @Override
            public void onSuccess(String version) {
                GetVersionProgressDialog.this.dialog.setVisible(false);
                JOptionPane.showMessageDialog(GetVersionProgressDialog.this.frame, "The Server says: \"" + version + "\"", "Remote Service", 1);
            }

            @Override
            public void onFailure() {
                GetVersionProgressDialog.this.dialog.setVisible(false);
                JOptionPane.showMessageDialog(GetVersionProgressDialog.this.frame, "Can't connect to server!", "Remote Service", 0);
            }
        });
        this.dialog = new JDialog((Frame)this.frame, true);
        this.dialog.getContentPane().add(panel);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.frame);
        this.dialog.setVisible(true);
    }

    @EventHandler(swingEDT=true)
    public void handle(RemoteServiceAbortEvent event) {
        logger.info("" + event);
    }
}

