/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.remoteservice.listtags;

import de.eobs.setuptool.eventbus.EventBus;
import de.eobs.setuptool.eventbus.EventHandler;
import de.eobs.setuptool.remoteservice.RemoteService;
import de.eobs.setuptool.remoteservice.RemoteServiceProgressPanel;
import de.eobs.setuptool.remoteservice.listtags.NewTagInfoListEvent;
import de.eobs.setuptool.rest.api.TagInfo;
import de.eobs.setuptool.taglistdialog.TagSelectEvent;
import java.awt.Frame;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListTagsProgressDialog {
    private static final Logger logger = LoggerFactory.getLogger(ListTagsProgressDialog.class);
    private JDialog dialog;
    private final EventBus eventBus;
    private JFrame frame;
    private final RemoteService remoteService;

    public ListTagsProgressDialog(JFrame frame, EventBus eventBus, RemoteService remoteService) {
        this.frame = frame;
        this.eventBus = eventBus;
        this.remoteService = remoteService;
    }

    @EventHandler(swingEDT=true)
    public void handle(TagSelectEvent event) {
        logger.info("" + event);
        RemoteServiceProgressPanel panel = new RemoteServiceProgressPanel();
        panel.updateText("connecting server...");
        this.remoteService.listTags(new RemoteService.ListTagsHandler(){

            @Override
            public void onSuccess(List<TagInfo> tagInfos) {
                ListTagsProgressDialog.this.dialog.setVisible(false);
                ListTagsProgressDialog.this.eventBus.publish(new NewTagInfoListEvent(tagInfos));
            }

            @Override
            public void onFailure(RemoteService.ErrorCode ec) {
                ListTagsProgressDialog.this.dialog.setVisible(false);
                if (ec == RemoteService.ErrorCode.Unauthorized) {
                    JOptionPane.showMessageDialog(ListTagsProgressDialog.this.frame, "You are not authorized to download these tag configs! Please check tag-id and password.", "Remote Service", 0);
                } else {
                    JOptionPane.showMessageDialog(ListTagsProgressDialog.this.frame, "Can't connect to server!", "Remote Service", 0);
                }
            }
        });
        this.dialog = new JDialog((Frame)this.frame, true);
        this.dialog.setTitle("Download Tag Configurations");
        this.dialog.getContentPane().add(panel);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.frame);
        this.dialog.setVisible(true);
    }
}

