/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.remoteservice.sendtagconfig;

import de.eobs.setuptool.event.SendTagConfigToServerEvent;
import de.eobs.setuptool.event.SendTagConfigsToServerEvent;
import de.eobs.setuptool.eventbus.EventBus;
import de.eobs.setuptool.eventbus.EventHandler;
import de.eobs.setuptool.remoteservice.RemoteService;
import de.eobs.setuptool.remoteservice.RemoteServiceProgressPanel;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendTagConfigToServerProgressDialog {
    private static final Logger logger = LoggerFactory.getLogger(SendTagConfigToServerProgressDialog.class);
    private final JFrame frame;
    private final EventBus eventBus;
    private final RemoteService remoteService;
    private JDialog dialog;

    public SendTagConfigToServerProgressDialog(JFrame frame, EventBus eventBus, RemoteService remoteService) {
        this.frame = frame;
        this.eventBus = eventBus;
        this.remoteService = remoteService;
    }

    @EventHandler(swingEDT=true)
    public void handle(SendTagConfigToServerEvent event) {
        ArrayList<SendTagConfigToServerEvent> events = new ArrayList<SendTagConfigToServerEvent>();
        events.add(event);
        this.handle(new SendTagConfigsToServerEvent(events));
    }

    @EventHandler(swingEDT=true)
    public void handle(SendTagConfigsToServerEvent events) {
        logger.info("" + events);
        RemoteServiceProgressPanel panel = new RemoteServiceProgressPanel();
        panel.updateText("connecting server...");
        this.remoteService.updateTagConfigs(events, new RemoteService.UpdateTagConfigHandler(){

            @Override
            public void onSuccess() {
                SendTagConfigToServerProgressDialog.this.dialog.setVisible(false);
                JOptionPane.showMessageDialog(SendTagConfigToServerProgressDialog.this.frame, "Updated tag config!", "Remote Service", 1);
            }

            @Override
            public void onFailure() {
                SendTagConfigToServerProgressDialog.this.dialog.setVisible(false);
                JOptionPane.showMessageDialog(SendTagConfigToServerProgressDialog.this.frame, "Can't connect to server!", "Remote Service", 0);
            }
        });
        this.dialog = new JDialog((Frame)this.frame, true);
        this.dialog.getContentPane().add(panel);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.frame);
        this.dialog.setVisible(true);
    }
}

