/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.taglistdialog;

import com.google.common.primitives.Ints;
import de.eobs.setuptool.eventbus.EventBus;
import de.eobs.setuptool.eventbus.EventHandler;
import de.eobs.setuptool.remoteservice.gettaglist.NewTagListEvent;
import de.eobs.setuptool.rest.api.TagId;
import de.eobs.setuptool.taglistdialog.TagListPanel;
import de.eobs.setuptool.taglistdialog.TagSelectEvent;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class TagListDialog {
    private JFrame frame;
    private JDialog dialog;
    private EventBus eventBus;

    public TagListDialog(JFrame frame, EventBus eventBus) {
        this.frame = frame;
        this.eventBus = eventBus;
    }

    @EventHandler(swingEDT=true)
    public void handle(NewTagListEvent event) {
        ArrayList<TagId> tagList = new ArrayList<TagId>(event.getTagList());
        Collections.sort(tagList, new Comparator<TagId>(){

            @Override
            public int compare(TagId o1, TagId o2) {
                return Ints.compare((int)o1.getValue(), (int)o2.getValue());
            }
        });
        TagListPanel panel = new TagListPanel(tagList, new TagListPanel.Handler(){

            @Override
            public void onSelect(TagId tagId) {
                TagListDialog.this.dialog.setVisible(false);
                TagListDialog.this.eventBus.publish(new TagSelectEvent(tagId));
            }

            @Override
            public void onCancel() {
                TagListDialog.this.dialog.setVisible(false);
            }
        });
        this.dialog = new JDialog((Frame)this.frame, true);
        this.dialog.setTitle("Available Tags");
        this.dialog.getContentPane().add(panel);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.frame);
        this.dialog.setVisible(true);
    }
}

