/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.taglistdialog;

import de.eobs.setuptool.rest.api.TagId;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;

public class TagListPanel
extends JPanel {
    private final Handler handler;
    private final List<TagId> tagList;
    private JScrollPane scrollPane1;
    private JList list1;
    private JButton buttonCancel;
    private JButton buttonSelect;

    public TagListPanel(final List<TagId> tagList, Handler handler) {
        this.tagList = tagList;
        this.handler = handler;
        this.initComponents();
        this.list1.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return tagList.size();
            }

            @Override
            public Object getElementAt(int index) {
                return "Tag #" + ((TagId)tagList.get(index)).getValue();
            }
        });
    }

    private void buttonCancelActionPerformed(ActionEvent e) {
        this.handler.onCancel();
    }

    private void buttonSelectActionPerformed(ActionEvent e) {
        int index = this.list1.getSelectedIndex();
        if (index >= 0) {
            this.handler.onSelect(this.tagList.get(index));
        }
    }

    private void initComponents() {
        this.scrollPane1 = new JScrollPane();
        this.list1 = new JList();
        this.buttonCancel = new JButton();
        this.buttonSelect = new JButton();
        this.list1.setSelectionMode(0);
        this.scrollPane1.setViewportView(this.list1);
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagListPanel.this.buttonCancelActionPerformed(e);
            }
        });
        this.buttonSelect.setText("Select");
        this.buttonSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagListPanel.this.buttonSelectActionPerformed(e);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGap(0, 266, Short.MAX_VALUE).addComponent(this.buttonSelect).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addComponent(this.scrollPane1, -1, 376, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane1, -1, 249, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonSelect)).addContainerGap()));
    }

    static interface Handler {
        public void onSelect(TagId var1);

        public void onCancel();
    }
}

