/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.templates;

import de.eobs.setuptool.TableUtils;
import de.eobs.setuptool.templates.TagConfigTemplateJson;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;

public class SelectTemplatePanel
extends JPanel {
    private final Handler handler;
    List<TemplateItem> items = new ArrayList<TemplateItem>();
    private JScrollPane scrollPane1;
    private JTable table1;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JLabel label1;
    private JScrollPane scrollPane2;
    private JTextArea textArea_comment;
    private JLabel label2;
    private JScrollPane scrollPane3;
    private JTextArea textArea_info;

    public SelectTemplatePanel(final Handler handler) {
        this.handler = handler;
        this.initComponents();
        TableUtils.configureTable(this.table1);
        this.table1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TemplateItem item;
                if (e.getClickCount() == 1 && e.getButton() == 1) {
                    TemplateItem item2 = SelectTemplatePanel.this.getSelectedTemplateItem();
                    if (item2 != null) {
                        SelectTemplatePanel.this.updateGui(item2);
                    }
                } else if (e.getClickCount() == 2 && e.getButton() == 1 && handler != null && (item = SelectTemplatePanel.this.getSelectedTemplateItem()) != null) {
                    handler.onOk(SelectTemplatePanel.this, item.template);
                }
            }
        });
    }

    private void updateGui(TemplateItem item) {
        this.textArea_comment.setText(item.template.comment);
        this.textArea_comment.setCaretPosition(0);
        StringBuilder infoText = new StringBuilder();
        infoText.append("Tag Config Version: v" + item.template.other_version + "\n");
        this.textArea_info.setText(infoText.toString());
        this.textArea_info.setCaretPosition(0);
    }

    public JButton getOkButton() {
        return this.buttonOk;
    }

    public void updateGui(List<TagConfigTemplateJson> templates) {
        this.items.clear();
        for (TagConfigTemplateJson t : templates) {
            this.items.add(new TemplateItem(t));
        }
        Collections.sort(this.items, new Comparator<TemplateItem>(){

            @Override
            public int compare(TemplateItem o1, TemplateItem o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        this.table1.setModel(new MyTableModel());
        if (this.items.size() > 0) {
            this.table1.getSelectionModel().setSelectionInterval(0, 0);
            this.updateGui(this.items.get(0));
        }
    }

    private void buttonCancelActionPerformed(ActionEvent e) {
        if (this.handler != null) {
            this.handler.onCancel(this);
        }
    }

    private void buttonOkActionPerformed(ActionEvent e) {
        TemplateItem item;
        if (this.handler != null && (item = this.getSelectedTemplateItem()) != null) {
            this.handler.onOk(this, item.template);
        }
    }

    private TemplateItem getSelectedTemplateItem() {
        int index = this.table1.getSelectedRow();
        if (index >= 0 && index < this.items.size()) {
            return this.items.get(index);
        }
        return null;
    }

    private void initComponents() {
        this.scrollPane1 = new JScrollPane();
        this.table1 = new JTable();
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        this.label1 = new JLabel();
        this.scrollPane2 = new JScrollPane();
        this.textArea_comment = new JTextArea();
        this.label2 = new JLabel();
        this.scrollPane3 = new JScrollPane();
        this.textArea_info = new JTextArea();
        this.setPreferredSize(new Dimension(800, 400));
        this.table1.setSelectionMode(0);
        this.scrollPane1.setViewportView(this.table1);
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(e -> this.buttonCancelActionPerformed(e));
        this.buttonOk.setText("OK");
        this.buttonOk.addActionListener(e -> this.buttonOkActionPerformed(e));
        this.label1.setText("Comment");
        this.scrollPane2.setHorizontalScrollBarPolicy(31);
        this.scrollPane2.setViewportView(this.textArea_comment);
        this.label2.setText("Info");
        this.scrollPane3.setHorizontalScrollBarPolicy(31);
        this.textArea_info.setEditable(false);
        this.textArea_info.setFocusable(false);
        this.scrollPane3.setViewportView(this.textArea_info);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup().addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 451, Short.MAX_VALUE).addComponent(this.buttonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addGroup(layout.createSequentialGroup().addComponent(this.scrollPane1, -1, 299, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addComponent(this.scrollPane2, -1, 308, Short.MAX_VALUE).addComponent(this.scrollPane3, -1, 308, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.label1).addComponent(this.label2)).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.label1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane2, -1, 78, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.label2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane3, -1, 124, Short.MAX_VALUE)).addComponent(this.scrollPane1, -1, 252, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOk)).addContainerGap()));
    }

    class MyTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"Template Name", "Timestamp"};

        MyTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getRowCount() {
            return SelectTemplatePanel.this.items.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return SelectTemplatePanel.this.items.get((int)rowIndex).name;
            }
            if (columnIndex == 1) {
                return SelectTemplatePanel.this.items.get((int)rowIndex).template.getTimestampAsLocalString();
            }
            return "TODO(" + rowIndex + "," + columnIndex + ")";
        }
    }

    static class TemplateItem {
        public final TagConfigTemplateJson template;
        public final String name;

        public TemplateItem(TagConfigTemplateJson template) {
            this.name = template.name;
            this.template = template;
        }
    }

    public static interface Handler {
        public void onOk(SelectTemplatePanel var1, TagConfigTemplateJson var2);

        public void onCancel(SelectTemplatePanel var1);
    }
}

