/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.templates;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import de.eobs.setuptool.rest.api.TagId;
import de.eobs.setuptool.tagconfig.HeaderFields;
import de.eobs.setuptool.tagconfig.TagConfigGeneric;
import de.eobs.setuptool.tagconfig.U32;
import de.eobs.setuptool.templates.TagConfigJson;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.codec.binary.Base64;

public class TagConfigJsonUtils {
    public static TagConfigJson toJson(TagId tagId, TagConfigGeneric tagConfig) {
        TagConfigJson json = new TagConfigJson();
        json.tagId = tagId.getValue();
        json.eobs_tag_type = tagConfig.eobs_tag_type().getValue();
        json.software_major_version = tagConfig.software_major_version().getValue();
        json.other_version = tagConfig.other_version().getValue();
        json.magic = tagConfig.magic().getValue();
        json.swfeatures = HeaderFields.Feature.enabledFlags((U32)tagConfig.swfeatures());
        json.configBytes = Base64.encodeBase64String((byte[])tagConfig.toBytes());
        return json;
    }

    public static void writeJson(TagConfigJson json, Writer sw) throws IOException {
        ObjectWriter mapper = new ObjectMapper().writerWithDefaultPrettyPrinter();
        mapper.writeValue(sw, (Object)json);
    }

    public static TagConfigJson readJson(Reader reader) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        TagConfigJson json = (TagConfigJson)mapper.readValue(reader, TagConfigJson.class);
        return json;
    }

    public static void writeJson(TagConfigJson json, File file) throws IOException {
        ObjectWriter mapper = new ObjectMapper().writerWithDefaultPrettyPrinter();
        mapper.writeValue(file, (Object)json);
    }

    public static TagConfigJson readJson(File reader) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        TagConfigJson json = (TagConfigJson)mapper.readValue(reader, TagConfigJson.class);
        return json;
    }
}

