/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.templates;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class TagConfigTemplateJson {
    public String name;
    public String comment;
    public String timestamp;
    public int eobs_tag_type;
    public int software_major_version;
    public int other_version;
    public int magic;
    public long swfeatures;
    public String configBytes;
    @JsonIgnore
    static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"YYYY-MM-dd HH:mm");

    @JsonIgnore
    public DateTime getTimestampAsDateTime() {
        if (this.timestamp == null) {
            return null;
        }
        return ISODateTimeFormat.dateTime().parseDateTime(this.timestamp);
    }

    @JsonIgnore
    public String getTimestampAsLocalString() {
        DateTime t = this.getTimestampAsDateTime();
        if (t == null) {
            return "";
        }
        return FORMATTER.print((ReadableInstant)t);
    }

    @JsonIgnore
    public byte[] getConfigBytesAsByteArray() {
        return Base64.decodeBase64((String)this.configBytes);
    }
}

