/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.templates;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import de.eobs.setuptool.tagconfig.TagConfigGeneric;
import de.eobs.setuptool.templates.TagConfigTemplateJson;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class TagConfigTemplateJsonUtils {
    public static TagConfigTemplateJson toJson(String name, String comment, DateTime dateTime, TagConfigGeneric tagConfig) {
        TagConfigTemplateJson json = new TagConfigTemplateJson();
        json.name = name;
        json.comment = comment;
        json.timestamp = TagConfigTemplateJsonUtils.toString(dateTime);
        json.eobs_tag_type = tagConfig.eobs_tag_type().getValue();
        json.software_major_version = tagConfig.software_major_version().getValue();
        json.other_version = tagConfig.other_version().getValue();
        json.magic = tagConfig.magic().getValue();
        json.swfeatures = tagConfig.swfeatures().getValue();
        json.configBytes = Base64.encodeBase64String((byte[])tagConfig.toBytes());
        return json;
    }

    public static String toString(DateTime dateTime) {
        return ISODateTimeFormat.dateTime().print((ReadableInstant)dateTime);
    }

    public static void writeJson(TagConfigTemplateJson json, Writer sw) throws IOException {
        ObjectWriter mapper = new ObjectMapper().writerWithDefaultPrettyPrinter();
        mapper.writeValue(sw, (Object)json);
    }

    public static TagConfigTemplateJson readJson(Reader reader) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        TagConfigTemplateJson json = (TagConfigTemplateJson)mapper.readValue(reader, TagConfigTemplateJson.class);
        return json;
    }

    public static void writeJson(TagConfigTemplateJson json, File file) throws IOException {
        ObjectWriter mapper = new ObjectMapper().writerWithDefaultPrettyPrinter();
        mapper.writeValue(file, (Object)json);
    }

    public static TagConfigTemplateJson readJson(File reader) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        TagConfigTemplateJson json = (TagConfigTemplateJson)mapper.readValue(reader, TagConfigTemplateJson.class);
        return json;
    }
}

