/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.templates;

import de.eobs.setuptool.templates.TagConfigTemplateJson;
import java.awt.event.ActionEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class TemplatePanel
extends JPanel {
    private final Handler handler;
    private JLabel label1;
    private JLabel label2;
    private JTextField textField_name;
    private JScrollPane scrollPane1;
    private JTextArea textArea_comment;
    private JLabel label3;
    private JScrollPane scrollPane2;
    private JTextArea textArea_info;
    private JButton buttonCancel;
    private JButton buttonOk;
    private JTextField textField_timestamp;

    public void updateGui(TagConfigTemplateJson templateJson) {
        this.textField_name.setText(templateJson.name);
        this.textArea_comment.setText(templateJson.comment);
        this.textArea_comment.setCaretPosition(0);
        this.textField_timestamp.setText(templateJson.getTimestampAsLocalString());
        StringBuilder infoText = new StringBuilder();
        infoText.append("Tag Config Version: v" + templateJson.other_version + "\n");
        this.textArea_info.setText(infoText.toString());
        this.textArea_info.setCaretPosition(0);
    }

    public void updateModel(TagConfigTemplateJson templateJson) {
        templateJson.name = this.textField_name.getText();
        templateJson.comment = this.textArea_comment.getText();
    }

    public TemplatePanel(Handler handler) {
        this.handler = handler;
        this.initComponents();
    }

    public JButton getOkButton() {
        return this.buttonOk;
    }

    private void buttonCancelActionPerformed(ActionEvent e) {
        if (this.handler != null) {
            this.handler.onCancel(this);
        }
    }

    private void buttonOkActionPerformed(ActionEvent e) {
        if (this.handler != null) {
            this.handler.onOk(this);
        }
    }

    private void initComponents() {
        this.label1 = new JLabel();
        this.label2 = new JLabel();
        this.textField_name = new JTextField();
        this.scrollPane1 = new JScrollPane();
        this.textArea_comment = new JTextArea();
        this.label3 = new JLabel();
        this.scrollPane2 = new JScrollPane();
        this.textArea_info = new JTextArea();
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        this.textField_timestamp = new JTextField();
        this.label1.setText("Template Name");
        this.label2.setText("Comment");
        this.scrollPane1.setHorizontalScrollBarPolicy(31);
        this.scrollPane1.setViewportView(this.textArea_comment);
        this.label3.setText("Tag Configuration Info");
        this.scrollPane2.setHorizontalScrollBarPolicy(31);
        this.textArea_info.setEditable(false);
        this.scrollPane2.setViewportView(this.textArea_info);
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(e -> this.buttonCancelActionPerformed(e));
        this.buttonOk.setText("OK");
        this.buttonOk.addActionListener(e -> this.buttonOkActionPerformed(e));
        this.textField_timestamp.setEditable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.label1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.textField_name, -1, 283, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 226, Short.MAX_VALUE).addComponent(this.buttonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel)).addComponent(this.scrollPane1, -1, 388, Short.MAX_VALUE).addComponent(this.scrollPane2, GroupLayout.Alignment.TRAILING, -1, 388, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.label3).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.label2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 282, Short.MAX_VALUE).addComponent(this.textField_timestamp, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label1).addComponent(this.textField_name, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label2).addComponent(this.textField_timestamp, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane1, -1, 73, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.label3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane2, -1, 73, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCancel).addComponent(this.buttonOk)).addContainerGap()));
    }

    public static interface Handler {
        public void onOk(TemplatePanel var1);

        public void onCancel(TemplatePanel var1);
    }
}

