/*
 * Decompiled with CFR 0.152.
 */
package de.eobs.setuptool.templates;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import de.eobs.setuptool.templates.TagConfigTemplateJson;
import de.eobs.setuptool.templates.TagConfigTemplatesJson;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateStore {
    private static final Logger logger = LoggerFactory.getLogger(TemplateStore.class);
    private final File file;

    public static File getDefaultTemplateStoreFile() {
        return new File(System.getProperty("user.home"), "eobs-setuptool-templates.json");
    }

    public TemplateStore(File file) {
        this.file = file;
    }

    public List<TagConfigTemplateJson> getAll() throws IOException {
        try {
            if (this.file.exists() && this.file.length() > 0L) {
                ObjectMapper mapper = new ObjectMapper();
                TagConfigTemplatesJson json = (TagConfigTemplatesJson)mapper.readValue(this.file, TagConfigTemplatesJson.class);
                return json.templates;
            }
        }
        catch (Exception e) {
            logger.error("failed to load templates json file", (Throwable)e);
            JOptionPane.showMessageDialog(null, "Failed to load templates file.", "Load Configuration Templates", 2);
            try {
                logger.error("try to move old templates json file to '*.orig'");
                File origFile = new File(this.file.getAbsolutePath() + ".orig");
                Files.move(this.file.toPath(), origFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e2) {
                logger.error("failed to move old templates json file to '*.orig'", (Throwable)e2);
                try {
                    logger.error("try to delete old templates json file instead");
                    Files.delete(this.file.toPath());
                }
                catch (Exception e3) {
                    logger.error("failed to delete old templates json file", (Throwable)e3);
                }
            }
        }
        return new ArrayList<TagConfigTemplateJson>();
    }

    public boolean store(TagConfigTemplateJson template, boolean allowReplacing) throws IOException {
        List<TagConfigTemplateJson> allTemplates = this.getAll();
        for (int i = 0; i < allTemplates.size(); ++i) {
            TagConfigTemplateJson t = allTemplates.get(i);
            if (!t.name.equals(template.name)) continue;
            if (allowReplacing) {
                allTemplates.set(i, template);
                this.storeAll(allTemplates);
                return true;
            }
            return false;
        }
        allTemplates.add(template);
        this.storeAll(allTemplates);
        return true;
    }

    private void storeAll(List<TagConfigTemplateJson> templates) throws IOException {
        if (this.file.exists()) {
            File backupFile = new File(this.file.getAbsolutePath() + ".bak");
            Files.copy(this.file.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        File tmpFile = new File(this.file.getAbsolutePath() + ".tmp");
        TagConfigTemplatesJson json = new TagConfigTemplatesJson();
        json.templates = templates;
        ObjectWriter mapper = new ObjectMapper().writerWithDefaultPrettyPrinter();
        mapper.writeValue(tmpFile, (Object)json);
        Files.move(tmpFile.toPath(), this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public TagConfigTemplateJson findByName(String name) throws IOException {
        List<TagConfigTemplateJson> allTemplates = this.getAll();
        for (TagConfigTemplateJson t : allTemplates) {
            if (!t.name.equals(name)) continue;
            return t;
        }
        return null;
    }
}

